#define vec2 float2
#define vec4 float4
#define rgb xyz
#define rgba xyzw

typedef struct
{
	int width[8];
	int height[8];
	float cur_time;
	float total_time;
	float origROI[4];
	float resultROI[4];
	float angle;
}FilterParam;

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;

static int get_global_id0(__global FilterParam* param)
{
	return get_global_id(0) - param->origROI[0]* param->width[0];
}

static int get_global_id1(__global FilterParam* param)
{
	return get_global_id(1) - param->origROI[1]* param->height[0];
}

vec4 INPUTSRC(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}
	
vec4 INPUT(image2d_t ovelay1,  __global FilterParam* param, vec2 tc)
{
	return read_imagef(ovelay1, sampler, (vec2)(tc.x,tc.y) );
}

	// Filter WindowShades
__kernel void filter_WindowShades(__read_only image2d_t image,		// image buffer input
								  __read_only image2d_t merge,		// merge buffer input
								  __write_only image2d_t retImg,   	// image buffer output
								  __private float m_mergeAlpha,
								  __private int alpha)	 			// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image1);
	int height = get_image_height(image1);
	int W = get_global_size(0);
	int H = get_global_size(1);
	
	if(w >= width || h >= height)
			return;
	float2 resolution = (float2)(W,H);
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/resolution.xy;

	float4 orignalColor = INPUTSRC(image, param, uv); // bgra
	float4 overlayColor = INPUT(merge, param, uv); // bgra
	float sa = overlayColor.w * m_mergeAlpha;
	float da = 1.0f - sa;
	float4 fragColor = orignalColor * da + overlayColor * sa;
	fragColor.w = orignalColor.w;
	
	float factor = (float)(alpha)/100.0f;
	fragColor = fragColor * factor + (1.0f - factor) * orignalColor;
	
	write_imagef(retImg, (int2)(w, h), fragColor);
}


